#modname "EA Elymas v6.3"
#description "Adds the custom nation of Elymas to Early Ages. Elymas is a syndicate of cults, guilds, and occult fraternities ruled by a powerful mage. Despite limited influence, their mastery of magic is unparalleled. Elymas works in secret from the confines of their impenetrable tower, where they use research and ritual to amass unfathomable power."
#icon "EA_Elymas/Elymas_Banner.tga"
#version 6.3

--CHANGELOG:
--6.0.1 : started this changelog, created Elymas.
--6.0.2 : Fixed compatibility issues with mods interacting with spells.
--6.1 : Fixed item slots on heros.
--6.2 : Fixed defence commanders being incompatible with defense units.
--6.3 : Removed Master Smith from Alchemist Magus and Magus Lugal.

-- Unit slots: 14080-14099
-- Nation slots: 147
-- Site Slots: 1912-1914

-------- SPELLS --------
#selectspell "Monster Boar"
#restricted "Elymas"
#end

#selectspell 254 -- Hound of Twilight
#restricted "Elymas"
#end

#selectspell "Bind Keres"
#restricted "Elymas"
#end

#selectspell "Contact Scorpion Man"
#restricted "Elymas"
#end

#selectspell "Herd of Elephants"
#restricted "Elymas"
#end

#selectspell "Summon Mazzikim"
#restricted "Elymas"
#end

#selectspell "Summon Lilot"
#restricted "Elymas"
#end

#selectspell "Living Mercury"
#restricted "Elymas"
#end

#selectspell "Summon Se'irim"
#restricted "Elymas"
#end

#selectspell "Summon Shedim"
#restricted "Elymas"
#end

#selectspell "Call Cyclops Tribe"
#restricted "Elymas"
#end

#selectspell "Pride of Lions"
#restricted "Elymas"
#end

#selectspell "Sloth of Bears"
#restricted "Elymas"
#end

#selectspell "Herd of Buffaloes"
#restricted "Elymas"
#end


#newspell
#copyspell "Call Spectral Philosopher"
#name "Call Ancestral Elder"
#descr "Elymas has housed many dynasties of mages, scholars, and villains who have discovered powerful secrets, and mentored leagues of apprentices. Through the contracts they made with demons and the dead the ancestors of Elymas are bound to its immortal tower. Their souls are barred from the entering the underworld, and some are even unaware of their undead state of existence. The secrets and power of Elymas attracted wise elders who studied every type of knowledge, and handled administrative duties. The ghosts of these elders still linger and they walk the corridors of Elymas, seemingly unaware they have died. Their conclusions on the subject of magic will contribute to the research of the nation."
#details "The ancestors of Elymas are bound to its territory, and will gradually fade from existence if they leave it for a prolonged period of time."
#restricted "Elymas"
#fatiguecost 600
#onlyatsite 1912
#damagemon "Ancestral Elder"
#end

#newspell
#copyspell "Call Ancestral Elder"
#name "Call Ancestor Magus"
#descr "Elymas has housed many dynasties of mages, scholars, and villains who have discovered powerful secrets, and mentored leagues of apprentices. Through the contracts they made with demons and the dead the ancestors of Elymas are bound to its immortal tower. Their souls are barred from the entering the underworld, and some are even unaware of their undead state of existence. Elymas is the home of a powerful secret society of wizards and magi who perform rituals and commune with monsters. The ghosts of these magi still linger and they walk the corridors of Elymas, seemingly unaware they have died. Their knowledge of death magic has been increased by their undead state."
#details "The ancestors of Elymas are bound to its territory, and will gradually fade from existence if they leave it for a prolonged period of time."
#researchlevel 1
#fatiguecost 1100
#damagemon "Ancestor Magus"
#end

#newspell
#copyspell "Call Ancestral Elder"
#name "Call Ancestor Mercenary"
#descr "Elymas has housed many dynasties of mages, scholars, and villains who have discovered powerful secrets, and mentored leagues of apprentices. Through the contracts they made with demons and the dead the ancestors of Elymas are bound to its immortal tower. Their souls are barred from the entering the underworld, and some are even unaware of their undead state of existence. Elymas is not a city and has no organized army, instead using their power and treasure to hire clans of warriors and mercenaries. Some of these warriors became enchanted by the work of the magi, and remained in Elymas to seek unholy strength, artifacts, and immortality. The ghosts of these warriors still linger and they walk the corridors of Elymas, seemingly unaware they have died. Once awakened they will defend the tower of Elymas with fervent vigor."
#details "The ancestors of Elymas are bound to its territory, and will gradually fade from existence if they leave it for a prolonged period of time."
#researchlevel 0
#fatiguecost 500
#effect 10001
#damagemon "Ancestor Mercenary"
#end

#newspell
#copyspell "Call Ancestor Mercenary"
#name "Ancestral Guard"
#descr "This spell summons a handful of Ancestor Mercenaries. Ancestor Mercenaries are sacred, but cannot leave Elymas."
#researchlevel 3
#fatiguecost 1600
#nreff 5
#end

#newspell
#copyspell "Ancestral Guard"
#name "Ancestral Legion"
#descr "This spell summons an entire legion of Ancestor Mercenaries. Ancestor Mercenaries are sacred, but cannot leave Elymas."
#researchlevel 8
#fatiguecost 5800
#nreff 25
#end

#newspell
#copyspell 1200
#name "Enliven Statue"
#descr "An ancient statue from the halls of Elymas is given false life by this powerful enchantment. The statue is difficult to destroy but will revert to an inanimate state if there are no mages left on the battlefield, and was physically bound the original place of creation when it was first sculpted, meaning the enchantment will gradually lose effect if it strays far from its home."
#damage 14097
#nreff 1
#researchlevel 0
#pathlevel 0 1
#restricted "Elymas"
#end

#selectspell 357
#restricted "Elymas"
#end

#newspell
#copyspell 1113
#name "Rephaite Reanimation"
#descr "The necromancer travels to the sacred tombs of Elymas and enchants ten well-prepared corpses of the ancestor giants and gives them false life. Skeletons are undead and will fall apart if left on the battlefield without undead leadership."
#restricted "Elymas"
#fatiguecost 600
#damage -3002
#onlyatsite 1914
#end


----COMBAT
#selectspell "Call Ancestor"
#restricted "Elymas"
#end

#selectspell "Wrath of the Ancestors"
#restricted "Elymas"
#end

--Combat spells originally inspired and modified from Magic Explodes published by Not-Lola

#newspell
#copyspell 717
#name "Oshann's Nightmare"
#descr "The illusionist creates a frightening illusion of a Horror. Ordinary men will surely falter at the sight of a Horror, but those brave enough to fight the apparition will find it quite vulnerable."
#fatiguecost 100
#researchlevel 0
#pathlevel 0 1
#restricted "Elymas"
#end

#newspell
#copyspell 652
#name "Khastrum's Fulmination"
#descr "The caster gathers the energy of lightning in their body before sending it out to wreak havoc amongst their foes. Strong enemies can resist this spell, as it is not true lightning gathered in the clouds above."
#restricted "Elymas"
#spec 8411264
#nreff 1
#casttime 35
#range 35
#damage 20
#pathlevel 0 1
#researchlevel 0
#end

#newspell
#copyspell 635
#name "Etorn's Flame Bolt"
#descr "With this spell, a mage can quickly send a bolt of flame towards a target."
#casttime 60
#fatiguecost 10
#restricted "Elymas"
#researchlevel 2
#end
-- researchlevel 1

#newspell
#copyspell 897
#name "Etero's Liquify"
#descr "The targets are turned into pools of liquid flesh, causing instant death. If a target resists the spell he is only partially liquified and will probably become permanently crippled."
#fatiguecost 100
#researchlevel 2
#pathlevel 0 3
#restricted "Elymas"
#end

#newspell
#copyspell 906
#name "Gerin's Mass Polymorph"
#descr "The caster transforms his enemies into swine."
#casttime 70
#precision 15
#aoe 9007
#fatiguecost 99
#researchlevel 3
#restricted "Elymas"
#pathlevel 0 2
#end

#newspell
#copyspell 892
#name "Trozahr's Conflagration"
#descr "Many enemies are set ablaze. This spell ignores enemy armor, but it is not always strong enough to kill the victims. Also, rain or snow will put the flames out very quickly."
#fatiguecost 100
#casttime 40
#researchlevel 3
#restricted "Elymas"
#end

#newspell
#copyspell 696
#name "Anakron's Tremor"
#descr "With a mighty clap, the Earth itself shudders and a mighty tremor rumbles forth at the mage's command. The withered and the unprepared may find themselves seriously hurt in the aftermath."
#restricted "Elymas"
#fatiguecost 100
#casttime 120
#damage 10
#pathlevel 0 3
#researchlevel 4
#end

#newspell
#copyspell 698
#name "Crozin's Gifts from Heaven"
#descr "A strange whizzing sound emanates from the heavens. Soon, a barrage of meteors, glowing with astral fire, plummet from the Stellar Sphere onto the battlefield."
#restricted "Elymas"
#path 0 4
#path 1 3
#pathlevel 0 1
#pathlevel 1 2
#fatiguecost 100
#aoe 1003
#nreff 1009
#end
-- researchlevel 5

#newspell
#copyspell 714
#name "Wedalf's Necromatic Blast"
#descr "These blasts pass straight through armor and damages the targets' souls directly. If a target is slain he will be filled by the energies from this spell and rise as a soulless warrior."
#restricted "Elymas"
#aoe 1002
#nreff 2003
#end
-- researchlevel 6

#newspell
#copyspell 1354
#name "Zamonar's Mass Charm"
#descr "The victims of a Charm spell will become totally loyal to the caster of the spell. A charmed commander will retain all his special skills and magic items and use them for the benefit of his new master. All Pretender Gods are immune to this spell."
#restricted "Elymas"
#aoe 1001
#fatiguecost 200
#end
-- researchlevel 7

-------- MAGIC SITES --------
-- (cap only units come from here)

#newsite 1912
#name "Tower of Elymas"
#look 3
#path 4
#level 0
#rarity 5
#gems 4 3 -- 3S
#homecom "Alchemist Magus"
#homecom "Seer Magus"
#end

#newsite 1913
#name "Underkeep"
#look 8
#path 3
#level 0
#rarity 5
#gems 3 2 -- 2E
#gems 6 2 -- 2N
#adventureruin 15
#homecom 1534 -- Minotaur Lord
#homemon 14099 -- Minotaur
#homemon 518 -- Troll
#homemon 14098 -- Ogre
#homecom "Enchanter Magus"
#end

#newsite 1914
#name "Desecrated Necropolis"
#look 6
#path 5
#level 0
#rarity 5
#gems 5 2 -- 2D
#homecom "Conjurer Magus"
#homecom 428 --assassin
#end

-- Heros --
#newmonster 14080
#copystats 3414
#name "Adventurer"
#fixedname "Zarek"
#spr1 "EA_Elymas/ElymasZarek1.tga"
#spr2 "EA_Elymas/ElymasZarek2.tga"
#descr "The secrets of Elymas attract many unscrupulous villains who ally with the magi in exchange for treasures and power. Over time they build up vast collections of magical equipment and become acquainted with sorcery. Zarek is a master bounty hunter, thief, and assassin with an unstoppable thirst for money and loot. There is no bounty he will not take and nothing he will not steal, and he would turn against even Elymas if they didn't pay his stipend."
#cleararmor
#clearspec
#gcost 10000
#str 11
#stealthy 80
#assassin
#patience 3
#itemslots 2040326
#armor 186
#armor 119
#combatcaster
#ambidextrous 2
#magicskill 7 1
#onebattlespell "Mirror Image"
#heal
#end

#newmonster 14081
#copystats 2327
#name "Adventurer"
#fixedname "Stella"
#spr1 "EA_Elymas/ElymasStella1.tga"
#spr2 "EA_Elymas/ElymasStella2.tga"
#descr "The secrets of Elymas attract many unscrupulous villains who ally with the magi in exchange for treasures and power. Over time they build up vast collections of magical equipment and become acquainted with sorcery. Stella is a skilled enchanter who gets what she wants through intrigue, weaves grand conspiracies, and executes daring heists. She enjoys using illusions and mind control to pit allies against each other, and revels in wicked betrayals and backstabbings."
#clearspec
#clearweapons
#cleararmor
#clearmagic
#gcost 10000
#female
#maxage 100
#older -25
#mr 15
#mor 14
#str 10
#att 9
#def 10
#mor 13
#weapon 126
#armor 230
#armor 212
#itemslots 2040326
#glamour
#stealthy 40
#spy
#magicskill 7 2
#magicskill 6 2
#magicskill 8 1
#tmpglamourgems 1
#batstartsum1d6 2072
#onebattlespell "Elemental Fortitude"
#heal
#startage 0
#end

#newmonster 14082
#copystats 2330
#name "Adventurer"
#fixedname "Zerjus of Elymas"
#spr1 "EA_Elymas/ElymasZerjus1.tga"
#spr2 "EA_Elymas/ElymasZerjus2.tga"
#descr "The secrets of Elymas attract many unscrupulous villains who ally with the magi in exchange for treasures and power. Over time they build up vast collections of magical equipment and become acquainted with sorcery. The mad cleric Zerjus worships a powerful undead king, who has promised to turn him into a lich in return for a lifetime of spreading death and chaos. Zerjus seeks to collect powerful treasures and build an undead army with which he can conquer the world."
#clearweapons
#cleararmor
#clearspec
#clearmagic
#gcost 10000
#itemslots 2040326
#holy
#reinvigoration 1
#autohealer 1
#maxage 150
#older -25
#hp 11
#str 10
#att 11
#def 11
#mr 16
#mor 14
#armor 265
#armor 223
#weapon 89
#weapon 761
#reanimpriest
#magicskill 5 2
#magicskill 6 2
#magicskill 7 1
#magicskill 9 2
#combatcaster
#ambidextrous 2
#onebattlespell "Holy Avenger"
#heal
#end

#newmonster 14083
#name "Adventurer"
#fixedname "War King"
#spr1 "EA_Elymas/ElymasWarking1.tga"
#spr2 "EA_Elymas/ElymasWarking2.tga"
#descr "The secrets of Elymas attract many unscrupulous villains who ally with the magi in exchange for treasures and power. Over time they build up vast collections of magical equipment and become acquainted with sorcery. Little is known about the infamous mercenary who goes by the name of the War King. His origin is a mystery, he has unmatched combat prowess, and he is a merciless enforcer for those who hire him. Attracted by wealth, the War King has allied with the magi of Elymas, and is indifferent about slaying anyone who stands in their way."
#gcost 10000
#rcost 1
#rpcost 1
#itemslots 2040326
#hp 20
#size 4
#mor 15
#mr 13
#prec 10
#poorleader
#nomagicleader
#str 14
#att 15
#def 15
#ap 14
#enc 1
#mapmove 16
#maxage 100
#magicskill 0 1
#combatcaster
#onebattlespell "Personal Luck"
#ambidextrous 4
#weapon 840
#weapon 397
#armor 21
#armor 236
#armor 155
#heal
#end

#newmonster 14084
#copystats 650
#name "Adventurer"
#fixedname "Master Kelik"
#spr1 "EA_Elymas/ElymasKelik1.tga"
#spr2 "EA_Elymas/ElymasKelik2.tga"
#descr "The secrets of Elymas attract many unscrupulous villains who ally with the magi in exchange for treasures and power. Over time they build up vast collections of magical equipment and become acquainted with sorcery. Kelik was a wizard's apprentice who made a contract with a demon to surpass his master and seize control of his academy. Since then he has become a master of dark and destructive magics and is on an endless quest for treasure and might. Kelik is gathering strength and allies to perform a violent takeover of Elymas, and wrest the title of Magus Lugal. From there, it will surely be him who becomes Pantokrator."
#cleararmor
#clearweapons
#clearspec
#clearmagic
#gcost 10000
#itemslots 2040326
#mor 13
#armor 265
#weapon 238
#combatcaster
#onebattlespell "Air Shield"
#maxage 200
#older -25
#startage 0
#researchbonus 10
#heal
#magicskill 0 3
#magicskill 1 2
#magicskill 3 2
#holy
#end

#newmonster 14085
#copystats 3508
#name "Grand Master Magus"
#spr1 "EA_Elymas/ElymasGrandMaster1.tga"
#spr2 "EA_Elymas/ElymasGrandMaster2.tga"
#descr "The tower of Elymas is home to an innumerable amount of secret societies and fraternities of wizards and mages, who bicker amongst each each other over the secrets of magic and the correct way to do trivial things. A Grand Master Magus is a powerful and expierenced mage who has through time, connections, or might become the leader of a secret society. Grand Master Magi have unlocked secrets beyond the scope of most mere wizards, and may even be powerful enough to vye for the title of Magus Lugal of Elymas."
#clearweapons
#cleararmor
#clearspec
#clearmagic
#gcost 10000
#researchbonus 8
#hp 11
#mor 13
#startage 0
#maxage 150
#older -25
#weapon 9
#armor 249
#armor 230
#custommagic 65408 300
#custommagic 65408 100
#magicskill 9 2
#holy
#prophetshape 14086
#end

#newmonster 14086
#copystats 244
#name "Magus Lugal"
#spr1 "EA_Elymas/ElymasLugal1.tga"
#spr2 "EA_Elymas/ElymasLugal2.tga"
#descr "The Magus Lugal is the tyrant ruler of the tower of Elymas, holding supreme magic power and complete authority over the wizard societies. The Magus Lugal rules Elymas until their death, at which point the mages cast a vote on who they think should inherit the title. This process is drawn-out, tumultuous, and when contending magi disagree, they will simply duel or attempt to destroy eachother and the surviving mage, clearly having superior magical ability, is assumed to have the objectively superior argument and given the mandate of law. The crown of the Magus Lugal has Nephilim-esque horns in reverence of the founders, and the Magus Lugal carries a ceremonial staff of storms which they enjoy using to silence quarrels and smite insubordinates."
#cleararmor
#clearmagic
#clearweapons
#clearspec
#gcost 10000
#itemslots 2040326
#holy
#heal
#elementrange 1
#magicskill 0 2
#magicskill 1 2
#magicskill 2 1
#magicskill 3 2
#magicskill 9 2
#custommagic 1920 100
#inspiringres 1
#mor 14
#armor 231
#armor 212
#weapon 105
#weapon 243
#startage 0
#maxage 200
#older -25
#alchemy 25
#autodishealer 1
#researchbonus 8
#elementgems 1
#end

-- Leaders --

#newmonster 14087
#copystats 1892
#name "Alchemist Magus"
#spr1 "EA_Elymas/ElymasAlchemist1.tga"
#spr2 "EA_Elymas/ElymasAlchemist2.tga"
#descr "The Alchemist Magi of Elymas are wizards who have achieved mastery over the elements, and now work to uncover the secrets of alchemy on their path of enlightenment. They focus their research on the material applications of magic, and the transmutations of matter and essence. It is because of this that the alchemist's guild has taken the role of the treasurers of Elymas, creating and having control of the tower's collection of treasure, ingredients, and magical artifacts. Every month an Alchemist Magus will ply their trade, turning mundane and useless ingredients into magically potent gems. Alchemist Magi have unlocked secrets beyond the scope of most mere wizards, and may even be powerful enough to vye for the title of Magus Lugal of Elymas."
#cleararmor
#clearweapons
#clearspec
#clearmagic
#gcost 10000
#startage 0
#maxage 150
#older -25
#alchemy 25
#autodishealer 1
#elementgems 1
#magicskill 0 1
#magicskill 1 1
#magicskill 2 1
#magicskill 3 1
#mor 9
#custommagic 1920 100
#custommagic 1920 100
#researchbonus 6
#slowrec
#prophetshape 14086
#holy
#armor 158
#armor 249
#weapon 9
#end

#newmonster 14088
#copystats 301
#name "Seer Magus"
#spr1 "EA_Elymas/ElymasSeer1.tga"
#spr2 "EA_Elymas/ElymasSeer2.tga"
#descr "The Seer Magi are masters of divination and have collected untold amounts of knowledge on the movements and messages of the stars, sun, and moon. They obvserve the stars from the high rooms of the tower of Elymas, and through arcane visions are able to predict the future and observe far away lands. The Seer Magi have grouped themselves into a cult of the stars, and act as the intelligence network of Elymas, monitoring vassals and spying on enemies to hunt for secrets and quell their own paranoia."
#clearspec
#clearmagic
#gcost 10000
#nobadevents 10
#armor 158
#startage 0
#magicskill 4 2
#magicskill 9 1
#custommagic 3968 100
#custommagic 1920 100
#custommagic 1920 50
#researchbonus 4
#holy
#end

#newmonster 14089
#copystats 1182
#name "Enchanter Magus"
#spr1 "EA_Elymas/ElymasEnchanter1.tga"
#spr2 "EA_Elymas/ElymasEnchanter2.tga"
#descr "The Enchanter Magi are skilled in the paths of Nature and Glamour and specialize in the study of the land and the Earth. They belong to the secret society the Moose's Head, which has tasked itself with the care, study, and protection of the Underkeep, the vast and enigmatic dungeon beneath the tower of Elymas. In the Underkeep, the Enchanter Magi search for ancient treasures, learn lost magics, and make alliances with strange monsters."
#clearmagic
#gcost 10000
#startage 0
#mor 12
#prec 11
#mapmove 16
#startage 0
#magicskill 6 2
#magicskill 7 1
#custommagic 24576 100
#custommagic 38528 100
#custommagic 38528 10
#researchbonus 4
#holy
#end

#newmonster 14090
#copystats 95
#name "Conjurer Magus"
#spr1 "EA_Elymas/ElymasConjurer1.tga"
#spr2 "EA_Elymas/ElymasConjurer2.tga"
#descr "The Conjurer Magi of Elymas are members of the Snake Society, an enigmatic fraternity of sorcerers, demonologists, and other researchers and practicioners of dark magic. The Conjurer Magi practice ancestor worship and believe necromancy will allow them to commune with the long-dead founder giants of Elymas, who can teach them forgotten and untold secrets. The Snake Society is skilled in Blood magic, and may use the shrines and Temples of Elymas to create summoning circles and broker contracts with demons. Many guilds of unscrupulous mercenaries are employed by the Conjurer Magi, and the Conjurers themselves have a dedicated culture of dueling and swordplay making them skilled in combat."
#clearmagic
#cleararmor
#clearweapons
#clearspec
#gcost 10000
#str 10
#att 11
#def 11
#prec 11
#mor 13
#hp 10
#startage 0
#maxage 100
#templetrainer -3001
#holy
#researchbonus 4
#magicskill 8 1
#magicskill 5 2
#custommagic 36864 100
#custommagic 63488 10
#magicskill 9 1
#reanimpriest
#weapon 6
#armor 158
#armor 249
#end

#newmonster 14091
#copystats 3497
#name "Wizard Magus"
#spr1 "EA_Elymas/ElymasWizard1.tga"
#spr2 "EA_Elymas/ElymasWizard2.tga"
#descr "A Wizard Magus is a full member of the tower of Elymas. Wizard Magi travel to learn under different mentors and seek enlightening lore, allowing them to practice whatever magic they find most interesting. This means that a Wizard Magi's base of magical knowledge can vary, but most of the guilds of Elymas focus on one of the elemental paths."
#clearspec
#clearmagic
#gcost 10000
#rpcost 2
#str 9
#startage 0
#armor 158
#armor 249
#custommagic 1920 200
#custommagic 20352 100
#researchbonus 4
#holy
#end

#newmonster 14092
#copystats 2846
#copyspr 2846
#name "Ancestral Elder"
#descr "Elymas has housed many dynasties of mages, scholars, and villains who have discovered powerful secrets, and mentored leagues of apprentices. Through the contracts they made with demons and the dead the ancestors of Elymas are bound to its immortal tower. Their souls are barred from the entering the underworld, and some are even unaware of their undead state of existence. The secrets and power of Elymas attracted wise elders who studied every type of knowledge, and handled administrative duties. The ghosts of these elders still linger and they walk the corridors of Elymas, seemingly unaware they have died. Their conclusions on the subject of magic will contribute to the research of the nation."
#slothresearch 0
#homesick 20
#end

#newmonster 14093
#copystats 1539
#copyspr 1539
#name "Ancestor Magus"
#descr "Elymas has housed many dynasties of mages, scholars, and villains who have discovered powerful secrets, and mentored leagues of apprentices. Through the contracts they made with demons and the dead the ancestors of Elymas are bound to its immortal tower. Their souls are barred from the entering the underworld, and some are even unaware of their undead state of existence. Elymas is the home of a powerful secret society of wizards and magi who perform rituals and commune with monsters. The ghosts of these magi still linger and they walk the corridors of Elymas, seemingly unaware they have died. Their knowledge of death magic has been increased by their undead state."
#clearmagic
#magicskill 5 1
#custommagic 1152 100
#custommagic 1152 25
#custommagic 1152 25
#custommagic 1152 25
#homesick 20
#end

#newmonster 14094 --Brigand Leader
#copystats 1912
#copyspr 1912
#descr "Brigands are lawless humans who skulk about the wilderness and are known for their treacherous ways. Sometimes a leader unites several groups of brigands and villains."
#incunrest 0
#end

#newmonster 14095
#copystats 3509
#copyspr 3509
#name "Apprentice Magus"
#descr "A young member of the tower of Elymas. As an apprentice he is supposed to aid his master in magical research, but he has not been given full access to the magical resources of the tower. What spare time he has can be spent on whatever field of study his master finds most interesting."
#end

-- Soldiers/Monsters --

#newmonster 14096
#copystats 1541
#copyspr 1541
#name "Ancestor Mercenary"
#descr "Elymas has housed many dynasties of mages, scholars, and villains who have discovered powerful secrets, and mentored leagues of apprentices. Through the contracts they made with demons and the dead the ancestors of Elymas are bound to its immortal tower. Their souls are barred from the entering the underworld, and some are even unaware of their undead state of existence. Elymas is not a city and has no organized army, instead using their power and treasure to hire clans of warriors and mercenaries. Some of these warriors became enchanted by the work of the magi, and remained in Elymas to seek unholy strength, artifacts, and immortality. The ghosts of these warriors still linger and they walk the corridors of Elymas, seemingly unaware they have died. Once awakened they will defend the tower of Elymas with fervent vigor."
#homesick 20
#end

#newmonster 14097 --homesick statue
#copystats 474
#copyspr 474
#homesick 20
#end

#newmonster 14098 --greedy ogre
#copystats 2135
#copyspr 2135
#gcost 10020
#end

#newmonster 14099 --limited Minotaur
#copystats 234
#copyspr 234
#reclimit 3
#end

-------- NATION --------

#selectnation 147
#name "Elymas"
#epithet "Tower of Wizardry"
#era 1
#descr "Elymas is a colossal tower inhabited by human mages which dominates a badlands of monsters, beasts, and heathens. Once upon a time a powerful and ambitious sorcerer sought out a tribe of godlike giants. The giants taught him mastery of magic and secrets unknown to man, and when the sorcerer had learned enough to surpass the giants, he struck them down. Using the tribe as a sacrifice, a horde of demons was summoned, and a mighty and indestructible tower was constructed in seconds. The mages of Elymas are not a zealous or organized nation but are rather a tumultuous confederacy, united by shared interests and the tyranny of the Magus Lugal, their magocratic ruler. Elymas is home to countless fraternities, guilds, and secret societies of wizards and every path of magic is studied. Underneath the tower of Elymas is a seemingly endless dungeon, which can be explored to discover ancient treasures and recruit strange monsters. The mages have limited influence outside of their tower, and due to the ancient contracts they brokered with demons, their ancestors are bound even in death and cannot leave."
#summary "Race: Humans.
Military: Unorganized human and monster infantry. Vassalized tribes of horites, barbarians, and cynocephalians. Elite mages are sacred. Capital is guarded by demons, undead, and statues.
Magic: Skilled in Elements and Sorcery. Powerful mages are limited to capital. Has access to stronger national combat spells.
Priests: Weak."
#brief "Elymas is a syndicate of cults, guilds, and occult fraternities ruled by a powerful mage. Despite limited influence, their mastery of magic is unparalleled. Elymas works in secret from the confines of their impenetrable tower, where they use research and ritual to amass unfathomable power."
#color 0.2, 0.1, 0.5
#secondarycolor 0 1 1
#flag "EA_Elymas/ElymasFlag.tga"
#startsite "Tower of Elymas"
#startsite "Underkeep"
#startsite "Desecrated Necropolis"
#moremagic 1
#likesterr 64
#cavenation 0
#aifirenation
#aiairnation
#aiearthnation
#aiastralnation
#aideathnation
#aimagerec 75
#merccost 10
#fortera 0
#templepic 8
#homefort 24

#startcom 488 --Ettin
#startscout "Pilgrim"
#startunittype1 "Villain"
#startunitnbrs1 30

#hero1 14080
#hero2 14081
#hero3 14082
#hero4 14083
#hero5 14084
#multihero1 14085
#multihero2 488

-- Pretender settings --
#homerealm 10
#homerealm 5
#homerealm 3
#homerealm 7
#addgod 1025
#addgod 2082
#cheapgod20 120
#cheapgod20 216
#cheapgod20 655
#cheapgod20 1025
#cheapgod20 2082
#cheapgod20 2783
#cheapgod20 3416
#cheapgod40 179
#cheapgod40 872
-- Units --
#forestfortrec 139
#forestfortrec 140
#mountainfortrec "Horite"
#mountainfortrec "Horite Hunter"
#wastefortrec "Cynocephalian Hunter"
#wastefortrec "Cynocephalian Warrior"

#forestfortcom 141
#forestfortcom 147
#mountainfortcom "Horite Shaman"
#wastefortcom "Cynocephalian Chieftain"
#wastefortcom "Cynocephalian Shaman"
-- National Leaders -
#addreccom 14094 --Brigand leader
#addreccom "Pilgrim"
#addreccom "Wizard Magus"
#addreccom 14095 --Apprentice Magus
#addreccom 293 --Captain
-- National Units -
#addrecunit "Villain"
-- Province Defence --
#badindpd 1
#defcom1 190 --Mound King
#defcom2 "Wizard Magus"
#defunit1 191
#defunit1b 2124 --Longdead
#defunit2 303 --Imp
#defmult1 20
#defmult1b 10
#defmult2 10
#wallcom "Ancestor Magus"
#wallunit 2451 --Longspear dead
#wallmult 10
#wallunit 2286 --Fiery imp
#wallmult 10
#guardcom "Seer Magus" 
#guardunit 6802 --statues
#guardmult 10

#end
----- EVENTS ----

-- DEMON POOL --

#selectmonster 88
#montag 3001
#end

#selectmonster 303
#montag 3001
#montagweight 2
#end

#selectmonster 304
#montag 3001
#end

#selectmonster 489
#montag 3001
#end

#selectmonster 304
#montag 3001
#end

#selectmonster 526
#montag 3001
#end

#selectmonster 632
#montag 3001
#end

#selectmonster 638
#montag 3001
#end

#selectmonster 1662
#montag 3001
#end

#selectmonster 2072
#montag 3001
#montagweight 2
#end

#selectmonster 2073
#montag 3001
#end

#selectmonster 2074
#montag 3001
#end

#selectmonster 2286
#montag 3001
#montagweight 2
#end

#selectmonster 2287
#montag 3001
#montagweight 2
#end

#selectmonster 3127
#montag 3001
#end

#selectmonster 2794
#montag 3001
#end

-- RLONGDEAD POOL --

#selectmonster 2040
#montag 3002
#end

#selectmonster 2041
#montag 3002
#end

#selectmonster 2042
#montag 3002
#end

#selectmonster 2043
#montag 3002
#end

#selectmonster 2044
#montag 3002
#end
